# @brief Adds an executable target and performs related actions,
# such as verioning, binary dir and configuration.
# @note The default binary directory is PROJECT_BINARY_DIR, but can be overridden by specifying the ${PROJECT_NAME}_CURRENT_BINARY_DIR.
function(add_application)

message( STATUS "${PROJECT_NAME} linking libraries : ${ARGN}")

# Use PROJECT_BINARY_DIR by default, but override if necessary.
set(CURRENT_PROJECT_BINARY_DIR ${PROJECT_BINARY_DIR})
if (${PROJECT_NAME}_CURRENT_BINARY_DIR)
    set(CURRENT_PROJECT_BINARY_DIR ${${PROJECT_NAME}_CURRENT_BINARY_DIR})
endif()
message(STATUS "CURRENT_PROJECT_BINARY_DIR : ${CURRENT_PROJECT_BINARY_DIR}")

include_directories(${HSOA_VERSION_INCLUDE_DIR})

add_executable( ${PROJECT_NAME}
    ${HSOA_VERSION_SRC_FILE}
    ${SRC_LIST}
)

target_link_libraries( ${PROJECT_NAME}
    ${ARGN}
)

set_target_properties( ${PROJECT_NAME}
    PROPERTIES
        VERSION ${PROJECT_VERSION}
        RUNTIME_OUTPUT_DIRECTORY ${CURRENT_PROJECT_BINARY_DIR}/bin
)

# Copy the testconfig to the build dir, so the binaries are testable from the build dir.
# The created packages will not contain the testconfig but the production config instead. See installation.cmake.
if (EXISTS ${CMAKE_CURRENT_SOURCE_DIR}/testconfig/)
    file(COPY "${CMAKE_CURRENT_SOURCE_DIR}/testconfig/" DESTINATION "${CURRENT_PROJECT_BINARY_DIR}/etc")
endif()

endfunction()
